/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumMapper {
    private static final EnumMapper mapper = new EnumMapper();
    private final Map<Class<? extends Enum>, Entry> enums = new ConcurrentHashMap<Class<? extends Enum>, Entry>();

    public static EnumMapper getInstance() {
        return mapper;
    }

    private static final int getIntegerValue(Enum enum_) {
        if (enum_ instanceof IntegerEnum) {
            return ((IntegerEnum)((Object)enum_)).intValue();
        }
        return enum_.ordinal();
    }

    private Entry createEntry(Class<? extends Enum> clazz) {
        Entry entry = new Entry();
        for (Enum enum_ : clazz.getEnumConstants()) {
            int n = EnumMapper.getIntegerValue(enum_);
            entry.enumMap.put(n, enum_);
            entry.valueMap.put(enum_, n);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry getEntry(Class<? extends Enum> clazz) {
        Entry entry = this.enums.get(clazz);
        if (entry == null) {
            Class<? extends Enum> clazz2 = clazz;
            synchronized (clazz2) {
                if (!this.enums.containsKey(clazz)) {
                    entry = this.createEntry(clazz);
                    this.enums.put(clazz, entry);
                } else {
                    entry = this.enums.get(clazz);
                }
            }
        }
        return entry;
    }

    public int intValue(Enum enum_) {
        return EnumMapper.getIntegerValue(enum_);
    }

    public <E extends Enum<E>> E valueOf(int n, Class<E> clazz) {
        Enum enum_ = this.getEntry(clazz).enumMap.get(n);
        if (enum_ == null) {
            try {
                return Enum.valueOf(clazz, "__UNKNOWN_NATIVE_VALUE");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("No known Enum mapping for value " + n + " of type " + clazz.getName());
            }
        }
        return (E)((Enum)clazz.cast(enum_));
    }

    private static final class Entry {
        Map<Integer, Enum> enumMap = new HashMap<Integer, Enum>();
        Map<Enum, Integer> valueMap = new HashMap<Enum, Integer>();

        private Entry() {
        }
    }

    public static interface IntegerEnum {
        public int intValue();
    }
}

